 '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
  ' RS232 to 4FDO Ver 6.0002
 ' Gianni Pallotti, April 2017
 ' 4DFO PWM MMITE-44pins
 ' This program will get 4 Axis outputs from a SIM program and drive 4 DC motors
 ' visit <http://www.xsimulator.net/> for X-Sim Tools and support
 ' Interface Output: A<Axis1><Axis2><Axis3><Axis4>Z
 ' "A" marks the start and "Z" marks the end of the transmission
 ' NOTE: if signal is from RS-232 use "COM1:115200, inv" option
 ' If any Axis is not used, include <127> as value in the interface Output signal
 ' Any unused MM pot input should be bridged with 2 similar resistors (100K)to the +V and Gnd pins
 ' M1 and M2 control the Roll with P1 and P2
 ' M3 controls the Surge with P3
 ' M4 control the Sway with P4
 ' The supported TFT display is an ILI9341 with 2.4" touch screen
 ' Clear any previous setting <OPTION LCDPANEL DISABLE>
 ' Setting for LCD - <OPTION LCDPANEL ILI9341, rlandscape, 36, 32, 35>, use 'rlandscape' or 'landscape' option
 ' Setting for Touch Screen - <OPTION TOUCH 30, 31>
 ' Use command <GUI CALIBRATE> to set touch limits
 ' Test with <GUI TEST LCDPANEL>
 ' Test with <GUI TEST TOUCH>
 ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Pause 3000
Option autorun on
CPU 48
'-------------------------------------------------------------------------
Dim LimRoll As integer   ' limiter for Roll L and Roll R
Dim LimSurge As integer  ' limiter for Surge
Dim LimSway As integer   ' limiter for Sway
Dim Temp As integer
Dim race$ As string
'-------------------------------------------------------------------------
SetPin 27, ain  'M1 pot value input (Pot1) for Roll L
SetPin 26, ain  'M2 pot value input (Pot2) for Roll R
SetPin 25, ain  'M3 pot value input (Pot3) for Surge
SetPin 24, ain  'M4 pot value input (Pot4) for Sway
SetPin 4, DOUT  'M1 direction (Mot1Dir)
SetPin 3, DOUT  'M2 direction (Mot2Dir)
SetPin 1, DOUT 'M3 direction (Mot3Dir)
SetPin 2, DOUT 'M4 direction (Mot4Dir)
'-------------------------------------------------------------------------
'Offset to adjust power-off range, increase these values as required
Brk1=3     ' Roll L axis Brakes-On limiter M1
Brk2=3     ' Roll R axis Brakes-On limiter M2
Brk3=3     ' surge axis Brakes-On limiter M3
Brk4=3     ' sway axis Brakes-On limiter M4
'-------------------------------------------------------------------------
'Pots limiter for centering pot's angular movement
PotLimMx=0.666667       '180/270 = 180 pot movement ratio required, else = 1
PotLimMn=0.825          '0.825 = starting V value at 45', else = 0
'-------------------------------------------------------------------------
CLS
Text 1,1," ",L,13,1,RGB(black),RGB( 220, 220, 220)
Text 172,10, "MicroMite MK2 V5.3",,,,RGB(red),RGB(black)
Text 160,80, " 4DOF Axes ",L,1,2,RGB(cyan),RGB(black)
Text 160,120,"Controller ",L,1,2,RGB(cyan),RGB(black)
Text 180,180,"by: GBP2017 V6.0",L,,,RGB(WHITE),RGB(black)
Do:Loop Until Touch(x) >-1
'-------------------------------------------------------------------------
VAR restore
CLS
TEMPR START (19),0
Drawscreen
'-------------------------------------------------------------------------
Open "COM1:115200" As #1                      'NOTE: if signal from RS-232 use "COM1:115200,inv" option
Mot1 =510
Mot2 =510
Mot3 =510
Mot4 =510
'-------------------------------------------------------------------------
Do                                                 'Main program loop start
'-------------------------------------------------------------------------
Pot1 = Int((Pin(27)/PotLimMx-PotLimMn)*303)        'get Mot's pot value, adjust range and format to 4 digits (1000)
Pot2 = Int((Pin(26)/PotLimMx-PotLimMn)*303)
Pot3 = Int((Pin(25)/PotLimMx-PotLimMn)*303)
Pot4 = Int((Pin(24)/PotLimMx-PotLimMn)*303)
'-------------------------------------------------------------------------
datout$=""
dat$=Input$(1,#1)                                  'read 1 character from COM
 If dat$="A" Then
  datout$=Input$(5,#1)                             'read 4 character from COM
   If Right$(datout$,1)="Z" Then
     Mot1=Int(Asc(Left$(datout$,1))*4)             'format Mot's to 4 digits (1000)
     Mot2=Int(Asc(Mid$(datout$,2,1))*4)
     Mot3=Int(Asc(Mid$(datout$,3,1))*4)
     Mot4=Int(Asc(Mid$(datout$,4,1))*4)
   End If
 EndIf
'-------------------------------------------------------------------------
    If Mot1 - Pot1 >=0 Then                        'determining direction
       Pin(4) = 1                                  'set clockwise direction
    Else
       Pin(4) = 0                                  'set unticlockwise direction
    EndIf
    If Mot2 - Pot2 >=0 Then
       Pin(3) = 1
    Else
       Pin(3) = 0
    EndIf
    If Mot3 - Pot3 >=0 Then
       Pin(1) = 1
    Else
       Pin(1) = 0
    EndIf
    If Mot4 - Pot4 >=0 Then
       Pin(2) = 1
    Else
       Pin(2) = 0
    EndIf
'-------------------------------------------------------------------------
Mot1Hz = Abs((Mot1 - Pot1))                        'Motor 1 Roll L
Mot1Hz = Int(Mot1Hz * LimRoll/100)                 'apply 'Limiter'
If Mot1Hz =< Brk1 Then  Mot1Hz  = 0.00             'apply 'Brakes'
If Mot1Hz > 100 Then  Mot1Hz  = 100                'do not exceed Maximum Speed value

Mot2Hz = Abs((Mot2 - Pot2))                        'Motor 2 Roll R
Mot2Hz = Int(Mot2Hz * LimRoll/100)
If Mot2Hz =< Brk2 Then  Mot2Hz  = 0.00
If Mot2Hz > 100 Then  Mot2Hz  = 100

Mot3Hz = Abs((Mot3 - Pot3))                        'Motor 3 Surge
Mot3Hz = Int(Mot3Hz * LimSurge/100)
If Mot3Hz =< Brk3 Then  Mot3Hz  = 0.00
If Mot3Hz > 100 Then  Mot3Hz  = 100

Mot4Hz = Abs((Mot4 - Pot4))                        'Motor 4 Sway
Mot4Hz = Int(Mot4Hz * LimSway/100)
If Mot4Hz =< Brk4 Then  Mot4Hz  = 0.00
If Mot4Hz > 100 Then  Mot4Hz  = 100
   PWM 1,25000, Mot1Hz , Mot2Hz , Mot3Hz
   PWM 2,25000, Mot4Hz
'-------------------------------------------------------------------------
Text 200,46,Str$((Pot1),4),R,,,RGB(cyan)
Text 200,76,Str$((Pot2),4),R,,,RGB(cyan)
Text 200,106,Str$((Pot3),4),R,,,RGB(cyan)
Text 200,135,Str$((Pot4),4),R,,,RGB(cyan)

Text 265,46,Str$((Mot1),4),,,,RGB(cyan)
Text 265,76,Str$((Mot2),4),,,,RGB(cyan)
Text 265,106,Str$((Mot3),4),,,,RGB(cyan)
Text 265,135,Str$((Mot4),4),,,,RGB(cyan)
'-------------------------------------------------------------------------
'Update Temperature eading intervals
x =x+1
If x=1000 Then                             'read temperature after 1000 cycles
UpdateTemp
x=0
End If
'-------------------------------------------------------------------------
If Touch(x)>1 Then DoScreenCommands
Loop                                                 'Main program loop end
'-------------------------------------------------------------------------
Sub DoScreenCommands
'Adjust Rolls limits
If Touch(x)>=9 And Touch(x)<=109 And Touch(y)>=10 And Touch(y)<=30 Then
LimRoll = Fix(Touch(x)-8)
If LimRoll <1 Then LimRoll=0
If LimRoll >100 Then LimRoll=100
Box 9,11,99,18,1,RGB(black),RGB(black)
Box 9,11,LimRoll,18,1,RGB(yellow),RGB(yellow)
Roll$= Str$(Fix(LimRoll),3)
Text 86,36,Roll$,,,,RGB(cyan),RGB(black)
EndIf
'Adjust Surge limit
If Touch(x)>=9 And Touch(x)<=109 And Touch(y)>=56 And Touch(y)<=76 Then
LimSurge = Fix(Touch(x)-8)
If LimSurge <1 Then LimSurge =0
If LimSurge >100 Then LimSurge =100
Box 9,57,99,18,1,RGB(black),RGB(black)
Box 9,57,LimSurge,18,1,RGB(yellow),RGB(yellow)
Surge$= Str$(Fix(LimSurge),3)
Text 86,80,Surge$,,,,RGB(cyan),RGB(black)
EndIf
'Adjust Sway limit
If Touch(x)>=9 And Touch(x)<=109 And Touch(y)>=102 And Touch(y)<=122 Then
LimSway = Fix(Touch(x)-8)
If LimSway <1 Then LimSway =0
If LimSway >100 Then LimSway =100
Box 9,103,99,18,1,RGB(black),RGB(black)
Box 9,103,LimSway,18,1,RGB(yellow),RGB(yellow)
Sway$= Str$(Fix(LimSway),3)
Text 86,126,Sway$,,,,RGB(cyan),RGB(black)
EndIf
'Save parameters
If Touch(x)>=9 And Touch(x)<=109 And Touch(y)>=155 And Touch(y)<=202 Then
drawsavescreen
End If
End Sub
'-------------------------------------------------------------------------
Sub UpdateTemp
Temp = TEMPR(19)
Text 230,168, Str$(Temp),L,1,2,RGB(cyan)
If Temp > 60 Then
RBox 8,155,96,42,10,RGB(yellow),RGB(RED)
Text 22,160," OVER ",,,,RGB(white),RGB(REd)
Text 20,180,"HEATING",,,,RGB(WHITE),RGB(REd)
End                                              ' overheating occured - stop
End If
End Sub
'-------------------------------------------------------------------------
Sub drawsavescreen
CLS
Box 0,0,320,240,1,RGB(yellow)
Text 176,10," SAVE ",L,1,1,RGB(black),RGB(green)
Text 258,10," LOAD ",L,1,1,RGB(black),RGB(green)
Text 8,206,"4Axes controller",L,1,2,RGB(cyan),RGB(black)
Text 280,220,"V5.0",L,,,RGB(WHITE),RGB(black)
RBox 190,162,100,42,10,RGB(yellow),RGB(black)
Text 207,169,"DONE",L,1,2,RGB(yellow),RGB(black)
Text 30,20," ",L,10,1,RGB(black),RGB(red)          'draw F1 car
Text 30,65," ",L,11,1,RGB(black),RGB(green)        'draw GTR car
Text 30,118," ",L,12,1,RGB(black),RGB(yellow)      'draw Rally car
Circle 200,55,12,,,RGB(cyan)
Circle 200,95,12,,,RGB(cyan)
Circle 200,135,12,,,RGB(cyan)
Circle 280,55,12,,,RGB(cyan)
Circle 280,95,12,,,RGB(cyan)
Circle 280,135,12,,,RGB(cyan)

Select Case car
Case 1
Circle 280,55,12,,,RGB(cyan),RGB(red)
Case 2
Circle 280,95,12,,,RGB(cyan),RGB(red)
Case 3
Circle 280,135,12,,,RGB(cyan),RGB(red)
Case 4
Circle 280,55,12,,,RGB(cyan),RGB(red)
Case 5
Circle 280,95,12,,,RGB(cyan),RGB(red)
Case 6
Circle 280,135,12,,,RGB(cyan),RGB(red)
End Select

Do
If Touch(x)>=190 And Touch(x)<=210 And Touch(y)>=45 And Touch(y)<=65 Then
Do : Loop Until Touch(x)=-1
car =1
LimRoll1=LimRoll: LimSurge1=LimSurge: LimSway1=LimSway
Circle 200,55,12,,,RGB(cyan),RGB(red)
Circle 200,95,12,,,RGB(cyan),RGB(black)
Circle 200,135,12,,,RGB(cyan),RGB(black)
Circle 280,55,12,,,RGB(cyan),RGB(black)
Circle 280,95,12,,,RGB(cyan),RGB(black)
Circle 280,135,12,,,RGB(cyan),RGB(black)
VAR save  LimRoll1, LimSurge1, LimSway1, Car
End If

If Touch(x)>=190 And Touch(x)<=210 And Touch(y)>=85 And Touch(y)<=105 Then
Do : Loop Until Touch(x)=-1
car =2
LimRoll2=LimRoll: LimSurge2=LimSurge: LimSway2=LimSway
Circle 200,55,12,,,RGB(cyan),RGB(black)
Circle 200,95,12,,,RGB(cyan),RGB(red)
Circle 200,135,12,,,RGB(cyan),RGB(black)
Circle 280,55,12,,,RGB(cyan),RGB(black)
Circle 280,95,12,,,RGB(cyan),RGB(black)
Circle 280,135,12,,,RGB(cyan),RGB(black)
VAR save  LimRoll2, LimSurge2, LimSway2, Car
End If

If Touch(x)>=190 And Touch(x)<=210 And Touch(y)>=125 And Touch(y)<=145 Then
Do : Loop Until Touch(x)=-1
car =3
LimRoll3=LimRoll: LimSurge3=LimSurge: LimSway3=LimSway
Circle 200,55,12,,,RGB(cyan),RGB(black)
Circle 200,95,12,,,RGB(cyan),RGB(black)
Circle 200,135,12,,,RGB(cyan),RGB(red)
Circle 280,55,12,,,RGB(cyan),RGB(black)
Circle 280,95,12,,,RGB(cyan),RGB(black)
Circle 280,135,12,,,RGB(cyan),RGB(black)
VAR save  LimRoll3, LimSurge3, LimSway3, Car
End If

If Touch(x)>=270 And Touch(x)<=290 And Touch(y)>=45 And Touch(y)<=65 Then
Do : Loop Until Touch(x)=-1
car =1
Circle 200,55,12,,,RGB(cyan),RGB(black)
Circle 200,95,12,,,RGB(cyan),RGB(black)
Circle 200,135,12,,,RGB(cyan),RGB(black)
Circle 280,55,12,,,RGB(cyan),RGB(red)
Circle 280,95,12,,,RGB(cyan),RGB(black)
Circle 280,135,12,,,RGB(cyan),RGB(black)
LimRoll=LimRoll1: LimSurge=LimSurge1: LimSway=LimSway1
VAR save  LimRoll1, LimSurge1, LimSway1, Car
End If

If Touch(x)>=270 And Touch(x)<=290 And Touch(y)>=85 And Touch(y)<=105 Then
Do : Loop Until Touch(x)=-1
car =2
Circle 200,55,12,,,RGB(cyan),RGB(black)
Circle 200,95,12,,,RGB(cyan),RGB(black)
Circle 200,135,12,,,RGB(cyan),RGB(black)
Circle 280,55,12,,,RGB(cyan),RGB(black)
Circle 280,95,12,,,RGB(cyan),RGB(red)
Circle 280,135,12,,,RGB(cyan),RGB(black)
LimRoll=LimRoll2: LimSurge=LimSurge2: LimSway=LimSway2
VAR save  LimRoll2, LimSurge2, LimSway2, Car
End If

If Touch(x)>=270 And Touch(x)<=290 And Touch(y)>=125 And Touch(y)<=145 Then
Do : Loop Until Touch(x)=-1
car =3
Circle 200,55,12,,,RGB(cyan),RGB(black)
Circle 200,95,12,,,RGB(cyan),RGB(black)
Circle 200,135,12,,,RGB(cyan),RGB(black)
Circle 280,55,12,,,RGB(cyan),RGB(black)
Circle 280,95,12,,,RGB(cyan),RGB(black)
Circle 280,135,12,,,RGB(cyan),RGB(red)
LimRoll=LimRoll3: LimSurge=LimSurge3: LimSway=LimSway3
VAR save  LimRoll3, LimSurge3, LimSway3, Car
End If
If Touch(x)>=190 And Touch(x)<=290 And Touch(y)>=162 And Touch(y)<=204 Then
Do : Loop Until Touch(x)=-1
CLS
Drawscreen
exit Sub
End If
Loop
End Sub
'-------------------------------------------------------------------------
Sub drawscreen
Box 0,0,320,240,1,RGB(yellow)
Font 1,1
Text 120,10, "MicroMite   by- GBP2017",,,,RGB(white),RGB(black)
Text 8,206,"4Axes controller",L,1,2,RGB(cyan),RGB(black)
Text 280,220,"V6.0",L,,,RGB(WHITE),RGB(black)

RBox 8,155,96,42,10,RGB(yellow),RGB(black)            'Save
Text 18,170,"SAVE/LOAD",L,1,1,RGB(yellow),RGB(black)

Select Case car
Case 0
race$="?"
Case 1
race$="F-1"
LimRoll=LimRoll1: LimSurge=LimSurge1: LimSway=LimSway1
Case 2
race$="GTR"
LimRoll=LimRoll2: LimSurge=LimSurge2: LimSway=LimSway2
Case 3
race$="Rally"
LimRoll=LimRoll3: LimSurge=LimSurge3: LimSway=LimSway3
End Select
Text 110,155,race$,L,1,1,RGB(yellow),RGB(black)

Box 8,10,101,20,1,RGB(green)                           'Roll Limits
Text 8,36,"Roll Lim.%",,,,RGB(cyan),RGB(black)
If LimRoll > 0 Then
Box 9,11,LimRoll,18,1,RGB(yellow),RGB(yellow)
Text 86,36,Str$(LimRoll,3),,,,RGB(cyan),RGB(black)
End If

Box 8,56,101,20,1,RGB(green)                           'Surge Limits
Text 8,80,"Surg Lim.%",,,,RGB(cyan),RGB(black)
If LimSurge > 0 Then
Box 9,57,LimSurge,18,1,RGB(yellow),RGB(yellow)
Text 86,80,Str$(LimSurge,3),,,,RGB(cyan),RGB(black)
End If

Box 8,102,101,20,1,RGB(green)                          'Sway Limits
Text 8,126,"Sway Lim.%",,,,RGB(cyan),RGB(black)
If LimSway > 0 Then
Box 9,103,LimSway,18,1,RGB(yellow),RGB(yellow)
Text 86,126,Str$(LimSway,3),,,,RGB(cyan),RGB(black)
End If

Text 130,30,"CHAIR      GAME ",,,,RGB(cyan)
Text 130,46,"POT1: ",,,,RGB(cyan)
Text 130,76,"POT2: ",,,,RGB(cyan)
Text 130,106,"POT3: ",,,,RGB(cyan)
Text 130,135,"POT4: ",,,,RGB(cyan)

Text 220,46,"MOT1: ",,,,RGB(cyan)
Text 220,76,"MOT2: ",,,,RGB(cyan)
Text 220,106,"MOT3: ",,,,RGB(cyan)
Text 220,135,"MOT4: ",,,,RGB(cyan)

Text 140,168, "Temp:",L,1,2,RGB(Green)                   'Draw Temperature
Temp = TEMPR(19)
If temp = 1000 Then
Text 230,168, "N/A",,1,2,RGB(cyan)                       'If temperature sensor not found
Else
Text 230,168, Str$(Temp),,1,2,RGB(cyan)
End If
Circle 280,170,3,,,RGB(cyan)
Text 285,168, "C",,1,2,RGB(cyan)
End Sub
'---------------------------------------------------------
' Data for F1 car as font
DefineFont #10
  01203C5A FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
  FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
  FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
  FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
  FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
  FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FCFFFFFF FFFFFF3F FFFFFFFF 0FFFFFFF
  FFFFFFFF FFFFFFFF FF87FFFF FFFFFFFF FFFFFFFF FF7FECFF FFFF7FE0 FFFFFFFF
  F8FFE7FB FFFFFF1F FEFFFFFF F3FEFFFC FFFFFFFF BFFFFFFF FFBEFF9F FFFFFFFF
  FBF7F8FF FF9FEFFF FFFFFFFF 7FFF93FD FFFFF0F9 FEE3FFFF FFE71F30 FFFF3F7F
  8CFFF0FF DFFFFCF9 00FFFFCF 3FE1FF00 F303C6FF 3F80FFFF 7F00F887 FF7C00FE
  FE07C0FF FFC3FF70 FC3F0F80 E1FF4120 E03FFEFF 98F8CF81 38FE3744 88F0F307
  2A1CF973 FCFFFF81 0C551C7F 8112BEF9 E7FFF7FF 3D2305FE 7F9482FF 7FFEFFFD
  7FCE508A FF17C5F0 E2E7FF7F 04C027CC DF3F4004 8878FEFF 0C00FC03 FFF0E151
  C328CEF3 A0C477FE 03C09F7F FF5801FF 036AF09D FF9FFF09 803F58C1 5D0E2006
  E0FCFF9F DD910F21 B8E78387 07F0F8FF 7007E087 81F3FD01 03E0FFE0 001C00F0
  000000FF FE000000 7FC00700 000000E0 FF7F8000 FF7FF8FF FFFFFFFF FFFF7FF8
  FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
  FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
  FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
  FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
  FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
  FFFFFFFF FFFFFFFF
End DefineFont
' Data for GTR car as font
DefineFont #11
   01203C5A FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
  FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
  FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
  FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
  FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF E0FFFFFF FFFF0100
  FFFFFFFF FFE7FFFF FFFF0FDC FFFFFFFF FF01F0FF FFFFFFCC FFFFFFFF 3DB0BFFB
  FFC0FFDF F9FFFFFF B9E1ECDF FF3FE0FF E7FCFFFF 3F171FFB FFFF0FF8 FE77FEFF
  FC77F2C3 FFFFFF03 B4FF7BFF 00FFEE3E FFFFFFFF C7EDFFB8 3FC0C1DD 9DFFFFFF
  EF78F36F FF0F008F 81DCFFFF FF07DFFC FFFF0FFC 7E6F8EFF FFFFC337 FCFFFFE7
  0E6F3200 FCFF0300 0FF0FFFF FF03009C BF0100E0 FF3FE0FF FFDFFFFF FF0FFEFF
  FFFFFFE1 FFFFF7FF E3FF83FF 007800C0 FFFFFF0D CFE1FFE0 FBFDE2FF FCFFFF7F
  03CFF33F DF7E3FFF 17FF07FC 3F000FF9 FEB7BFDF FCE5FF00 F7078043 00FED9EF
  37BEFF1F FBFD01C0 0700FFF6 F0A387FF 1D1C3F00 FFD0C1BF 22F8D1E1 EF6EF707
  F83F48E1 A10CFE74 F873B7FB 1DFE0F5C 7D3C09FF 0FFEDDED 0087FF01 770FDC01
  50837F6F F0DFE17F BBBD8321 1FD0E7DF 3EFC77FC F7EEEEC0 FF8727F0 A000FF1D
  FC7DB73B 87FFB00B 0DDEC37F 06FEDEEB E8013CA0 7A033400 64837FF7 FCF90000
  0000800D 8019E03F 023F7F00 FFFF3F20 00000BF8 0000C03F 00000020 1FC0C080
  080004E0 20000000 F81F6000 00060001 00080000 00FC0F18 00800160 0F000300
  1C00FFFF FFFFFF00 FF07E0FF 80FFFFFF FFFFFF7F FFFF03FC FFF8FFFF FFFFFFFF
  FFFFFFE3 FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
  FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
  FFFFFFFF FFFFFFFF
End DefineFont
' Data for Rally car as font
DefineFont #12
   01203C5A FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
  FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
  FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFCF
  FFFFFFFF 83FFFFFF FFFFFFFF FFFFFFFF FF81FFFF FFFFFFFF 0000FCFF FFFF0000
  FFFFFFFF 000000FC FFFF3F01 FEFFFFFF 809FFF83 FFFFFF0F 67FEFFFF E3FDE3FF
  FFFFFFFF FF33FFFF FF7E7FE2 FFFFFFFF F8FF9DFF FFDFDFDF FFFFFFFF B3FDFFCC
  FFFFFBF7 EEFFFFFF 7DAFFFFF FFFF7FCF 3FF7FFFF 6DCFEBFF FFFFFFCF FF8FF3FF
  79DBF9FA FFFFFFFF F9FFC1FD 7F3F17BF FEFFFFFF EFFDBF67 FFEFFFE0 00F8FFFF
  8078FE6F FFFF5D00 1BFFC1FF FF0FBEFF FFFFBFFF 00C0FF07 FFFF3300 1FFCFFE7
  0F8007FC 3C00E0EE 00FFF8FF FCFBE701 BF070000 0080FFFD 00FE00F8 FEF70100
  BE0F0000 00303F12 06FF7500 82FF85FF 0080CE4F BFC17F18 3BEEFFF0 861F80F3
  1EF7F01F FC8EFBFF A7B91FE0 DF013BF8 78BEEFFE FEE3067F 00308003 031EE038
  817FD800 EFFF0640 800EF03B 70EF0F18 EEFBBF00 02E007FC 6C20F8FB BFE3FE37
  FEF81000 8D3472FE C0EFB8FF 7F1F2E34 7FC10AD9 FFF7FBEF F1DFC717 F85FB8C3
  8EFFFD00 60FD0771 FFFF17D4 AC0300FE 3558FE13 FFFFFF05 0CAAF8BF C10E027F
  CFFFFF7F 3FC309FE 60E0C0D7 00000000 F4C74103 FF1F0000 E0FFFFFF 04FE7168
  00000000 00000000 80FF7F1C FFFFFF03 0F00FFFF 01F0FFFF FFFFFFFF FF03E0FF
  FF00FEFF FFFFFFFF FFFF01F8 FF7FC0FF FFFFFFFF FFFFFF00 FFFFFFFF FFFFFFFF
  FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
  FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
  FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
  FFFFFFFF FFFFFFFF
End DefineFont
' Data for Opening page
DefineFont #13
   0120F0A0 00000000 FF1F0000 FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FF1FFFFF
  FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FF1FFFFF FFFFFFFF FFFFFFFF FFFFFFFF
  FFFFFFFF FF1FFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FF0FFFFF FFFFFFFF
  FFFFFFFF FFFFFFFF FFFFFFFF FF0FFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
  FF0FFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FF8FFFFF FFFFFFFF FFFFFFFF
  FFFFFFFF FFFFFFFF FF8FFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FF8FFFFF
  FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FF8FFFFF FFFFFFFF FFFFFFFF FFFFFFFF
  FFFFFFFF FF87FFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FF87FFFF FFFFFFFF
  FFFFFFFF FFFFFFFF FFFFFFFF FF87FFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
  FF87FFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FF87FFFF FFFFFFFF FFFFFFFF
  FFFFFFFF FFFFFFFF FF87FFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FF87FFFF
  FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FF87FFFF FFFFFFFF FFFFFFFF FFFFFFFF
  FFFFFFFF FF87FFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFC7FFFF FFFFFFFF
  FFFFFFFF FFFFFFFF FFFFFFFF FFC7FFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
  FFC7FFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFC7FFFF FFFFFFFF FFFFFFFF
  FFFFFFFF FFFFFFFF FFC7FFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFC7FFFD
  FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFC3FFFF FFFFFFFF FFFFFFFF FFFFFFFF
  FFFFFFFF FFC3FFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFC3FFFF FFFFFFFF
  FFFFFFFF FFFFFFFF FFFFFFFF FFC3FFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
  FFC3FFEF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFC3FFFF FFFFFFFF FFFFFFFF
  FFFFFFFF FFFFFFFF FFC3FFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFE3FFFF
  FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFE3FFDF FFFFFFFF FFFFFFFF FFFFFFFF
  FFFFFFFF FFE1FFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFE1FFFF FFFFFFFF
  FFFFFFFF FFFFFFFF FFFFFFFF FFE1FFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF
  FFE1FFFF FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFE1FFFF FFFFFFFF FFFFFFFF
  FFFFFFFF FFFFFFFF FFE1FFED FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFE1FFFF
  FFFFFFFF FFFFFFFF FFFFFFFF FFFFFFFF FFE1FFFF FFFFFFFF FFFFFFFF FF07E0FF
  FFFFFFFF FFE1FFFF FFFFFFFF FFFFFFFF FF0100FF FFFFFFFF FFE1FFFD FFFFFFFF
  FFFFFFFF FF0000FE FFFFFFFF FFE1FFFD FFFFFFFF FFFFFFFF FF0000F0 FFFFFFFF
  FFE1FFFF FFFFFFFF FFFFFFFF FF0000C0 FFFFFFFF FFE1FFFF FFFFFFFF FFFFFFFF
  FF0000C0 FFFFFFFF FFE1FFFF FFFFFFFF FFFFFFFF FF000000 FFFFFFFF FFF0FBFF
  FFFFFFFF FEFFFFFF FF000000 FFFFFFFF FFF0FFFF FFFFFFFF FCFFFFFF FF000000
  FFFFFFFF FFF0FFFF FFFFFFFF F8FFFFFF FF000000 FFFFFFBF FFF0FFFF FFFFFFFF
  F0FFFFFF FF000000 FFFFFF8F FFF0FFFF FFFFFFFF F0FFFFFF FF000000 FFFFFF8F
  FFF0F9FF FFFFFFFF E0FFFFFF FF000000 FAFFFF83 FFF00380 FFFFFFFF C0FFFFFF
  FF000000 CBFFFFDF FFF00380 FFFFFFFF 80FFFFFF FF000000 C2FFFFFF FFF0FF0D
  FFFFFFFF 80FFFFFF FF000000 FEFFFF9F FFF8F33A FFFFFFFF 00FFFFFF FF000000
  FFFFFFBF 7FF88FC3 FFFFFFFF 00FEFFFF FF000000 FFFFFFEF 7FF8BF8F FFFFFFFF
  00FCFFFF FF000000 FBFEFFC7 7FF8FFFC FFFFFFFF 00FCFFFF FF000000 56FFFFB7
  7FF8FFF3 FFFFFFFF 00F8FFFF FF010000 FFEF8FBE 7FF8FFFD FFFFFFFF 00F8FFFF
  FF010000 7FFF7F87 7FF8FFE7 FFFFFFFF 00F0FFFF FF010000 FCFFFFA1 7FF0FFFF
  FFFFFFFF 00E0FFFF FF010000 FF6F379E 7F80FFFF FFFFFFFF 00E0FFFF FF010000
  FFFFAF9A FF07FEFF FFFFFFFF 00C0FFFF FF010000 FFFFFF81 0738F8FF FFFFFFFF
  0080FFFF FF030800 FFFFF787 0130E0FF FFFFFFFF 0080FFFF FF030800 FFFFFF81
  0040C0FF FFFFFFFF 0080FFFF FF030800 FFFF7F80 308080FF FFFFFF7F 0000FFFF
  FF030800 FFBFFD80 380001FF FFFFFF3F 0000FFFF FF030800 FFFFDF81 FE0100FE
  FFFFFF1F 0000FEFF FF030800 FFFFB383 FF0700F8 FFFFFF0F 0000FCFF FF030810
  7FF82D83 FF0300E0 FFFFFF87 0000FCFF FF130810 3FE00383 EF010000 FFFFFF87
  0000FCFF FF070830 18000F80 F7010000 FFFFFF87 0000F8FF FF270C00 00001C80
  73E00100 FFFFFF83 0000F0FF FF270E00 803FFC80 8F010000 FFFFFF83 0000F0FF
  FF271200 80FFF083 FF390000 FFFFFFC1 0000E0FF FF071000 C0FF808F 9FE60500
  FFFFFFC1 0000C0FF FF071000 E0FF00BE BF040170 FFFFFFC1 0000C0FF FF071000
  E3FF00E0 0F0C04E0 FFFFFF81 000080FF FF071000 FF7F0080 667A0480 FFFFFFF1
  070000FF FF0F2000 DF7F0080 68F80000 FFFFFF71 0F0000FE FF0F2000 0F1C0080
  00FC0200 FFFFFF31 3F0000FE FF0F2000 1E000780 80FC0300 FFFF9F31 7E0000FC
  FF0F6000 7E803F80 28FE0100 FFFF7F30 FE0000F0 FF1F4000 7EC0FF80 18BC0100
  FFFF7F30 FE0100E0 FF1F6000 FFFFFF8F 7CF80180 FFFF7F31 FE010080 FF1F2000
  FFFFFFFF 3ED00080 FCFF7F21 FE010000 FF3F0000 FFDFFFFF 3EC000C0 F0FF3703
  FE010000 FF3F0000 FF8FFFFF 1E4000E0 E0FF3301 FE030100 FF3F0000 FF8FFFFF
  0D2000F8 80FDBF01 FE830F00 FF3F1E00 FF8FFFFF 073000FC 00FDBCF3 FEC33F00
  FF7F1E00 FF9FFFFF F71800FC 00BC9FC7 FEE3FF00 FF7F1600 FF1FFFFF F30700FC
  00189CCF FEF3FF01 FF7F0C00 FF1FFFFF FFC101FC 0000C01F FEFFFF03 FF7F1E00
  FF1FFFFF 38F001FE 0040C03F FEFFFF07 FF7F3600 FF3FFEFF 01FCF1FF 0000C0FF
  FCFFFF0F FFFFFC00 FF7FFEFF FFFFE3FF 0000C0FF F0FFFF07 FFFFF000 FF7FFCFF
  FFFFE3FF 0000C0FF E0FFFF03 FFFFE100 FF7FFCFF FFFFC7FF 0000F0FF 80F1FF03
  FFFF0300 FF7FFCFF FFFF8FFF 0000FCFF 0080FF01 FFFF03C0 FFFFF8FF FFFF8FFF
  0000FEFF 0000FE00 FFFF0740 FFFFF8FF FFFF0FFF 0000FEFF 00007C00 FFFF0700
  FFFFF0FF FFFFCFFF 0000FEFF 000F6000 FFFF0700 FCFFF1FF FFFFCF1D 0000FEFF
  003E0000 FFFF0F00 E0FFF1FF FFFF0F07 0000FEFF 00700000 FFFF0F00 01FCE3FF
  FFFF0FC0 0000FEFF 10000800 FFFF1F00 07C0E3FF FFFF0F00 0000FEFF C0F10700
  FFFF3F00 8500E3FF FFFF0F00 0000FEFF 00C00F00 FFFF3F00 4007C0FF FFFF0F00
  0000FFFF 00000000 FFFF3F00 000BC0FF FFFF0F00 0080FFFF 00000000 FFFF7F00
  0000C0FF FFFF0F00 0080FFFF 00000000 FFFFFF00 000080FF FFFF0F00 008001FE
  00000000 FFFFFF00 000080FF FFFF0700 000000E0 00000000 FFFFFF01 000000FF
  FFFF0300 00000000 00000000 FFFFFF03 000000FF FEFF0100 00000000 00000800
  FFFFFF03 000000FF F0FF0100 00000000 00000000 FFFFFF07 000000FF 82FF0000
  00000000 00000000 FFFFFF07 000080FF 007C0000 00000020 00000000 FFFFFF0F
  0000E0FF 00000000 0000F03F 00000000 FFFFFF0F 0000F0FF 00000000 0000F07F
  00000000 FFFFFF1F 0000F0FF 00000000 0000FCBF 00000000 FFFFFF1F 0000F8FF
  01000000 00F8F1FF 00000000 FFFFFF3F 0000FCFF 01780000 00E8FFFF 00000000
  FFFFFF3F 0000FFFF 013E0000 0040FCFF 00000000 FFFFFF3F 0080FFFF C00F0000
  0000C0FF 00000000 FFFFFF7F 0080FFFF F8010000 0000007F 00000000 FFFFFFFF
  00C0FFFF 7F000000 00000006 00000000 FFFFFFFF 00E0FFFF 1F000000 000000F8
  01000000 FFFFFFFF 00F0FFFF 07000000 000000F0 01000000 FFFFFFFF 00F8FFFF
  00000000 00000000 03000000 FFFFFFFF 00FCFFFF 00000000 00000000 03000000
  FFFFFFFF 00FCFFFF 00000000 00000000 07000002 FFFFFFFF 00FEFFFF 00000000
  00000000 07000004 FFFFFFFF 00FFFFFF 00000000 00000000 0F000004 FFFFFFFF
  80FFFFFF 00000200 00000000 0F000000 FFFFFFFF E0FFFFFF 00002E00 00000000
  1F000000 FFFFFFFF F0FFFFFF 00001F00 00000000 1F000000 FFFFFFFF F6FFFFFF
  00800700 00000000 3F000000 FFFFFFFF E3FFFFFF 00C00100 00000000 3F000002
  FFFFFFFF E3FFFFFF 00F00080 00000000 3F000006 FFFFFFFF F3FFFFFF 003000E0
  00000400 7F000005 FFFFFFFF F3FFFFFF 000000F8 00001E00 7F00000F FFFFFFFF
  F3FFFFFF 000000FC 00003E00 FF00001E FFFFFFFF F3FFFFFF 000000FF 00003E00
  FF01001E FFFFFFFF FBFFFFFF 0000C0FF 00001E00 FF01003C FFFFFFFF FBFFFFFF
  0000F0FF 00000000 FF030878 FFFFFFFF FBFFFFFF 0000F0FF 00000000 FF031078
  FFFFFFFF FBFFFFFF 0000C0FF 00000000 FF0F00F0 FFFFFFFF FBFFFFFF 000000FF
  00000000 FF3F00E0 FFFFFFFF FBFFFFFF 000000FE 01000000 FF7F00E0 FFFFFFFF
  F3FFFFFF 00F000F8 00000000 FFFF0180 FFFFFFFF F1FFFFFF 00F003E0 03000000
  FFFF0700 FFFFFFFF F0BFFFFF 00C00700 03000000 FFF80F00 FFFFFFFF 7010FFFF
  00801F00 07000000 3FE20F00 FFFFFFFF 1000FFFF 60007C00 02000000 8F9F5F00
  FFFFFFFF 0400FFFF F000F800 03000000 E73F9F00 FFFFFFFF 0000FFFF FC016000
  01000000 F17F0C00 FFFFFFFF 0000FFFF FF0F0000 00000100 FE3F0000 FFFFFF7F
  0080FFFF FF3F0078 00000080 FF1FC000 FFFFFF1F 00C0FFFF FF7F007C 00000000
  FF1F4002 FFFFFFCF 0180FFFF FEFF00FE 00000030 FF3F0007 FFFFFFE3 0180FFFF
  FC7F80FF 000000FC FF7F001C FFFFFFF8 0380FFFF FC3F80FF 000000FE FF7F0018
  FFFF7FFE 0380FFFF F80FE0FF 000000FF FFFF0030 FFFFBFFF 1FC1FFFF F907F0FF
  0000C0FF FFFF00C0 FFFF3FFF FFE3FFFF F903F8FF 0100E0FF FF0F0480 FFFF3FFE
  FFFFFFFF F101FEFF 0700C0FF FF0F0000 FF3F3FFC FFFFFFFF 7300FFFF 1C0000FF
  FF330000 FF0F3CF0 FFFFFFFF 2380FFFF 380000FE FF672000 FF8F3BF0 FFFFFFFF
  07C0FFFF 600000FE FF7D0000 FFE737C0 FFFFFFFF 07F0FFFF C00100FE FF5B0000
  FFC32F80 FFFFFFFF 03F8FFFF 000000FF FF070000 FFC31F00 FFFFFFFF 01FCFFFF
  000000FF FE0F0000 FFC13F00 FFFFFFFF 00FEFFFF 020082FF F87F0000 FF613F00
  FFFFFFFF 80FFFFFF 0000CC3F F03F0000 FF10FE00 FFFFFFFF C0FFFFFF 0000FC1F
  E07F0000 FF10FC00 FFFFFFFF E0FFFFFF 0000F80F C07F8000 FF01F801 FFFFFFFF
  F8FFFFFF 0000E007 80FF0D00 FF21F803 FFFFFFFF F8FFFFFF 0000C003 00FE0F00
  FF23F807 FFFFFFFF FEFFFFFF 00000000 00BC3F00 FFFF8007 FFFFFFFF FFFFFFFF
  00000000 00703F00 FFFF0700 FFFFFFFF FFFFFFFF 00000080 00603C00 FFFF0F00
  FFFFFFFF FFFFFFFF 000000C0 00007800 FFFF1F20 FFFFFFFF FFFFFFFF 000000F0
  0020B00E FFFF3F00 FFFFFFFF FFFFFFFF 000000F8 0070C00F FFFF7F00 FFFFFFFF
  FFFFFFFF 000001FC 00F0800F FFFFFF00 FFFFFFFF FFFFFFFF 000000FE 02F00107
  FFFFFF01 FFFFFFFF FFFFFFFF 000080FF 07F00300 FFFFFF03 FFFFFFFF FFFFFFFF
  0000C0FF 0EF00700 FFFFFF07 FFFFFFFF FFFFFFFF 0000E0FF 3CF00700 FFFFFF0F
  FFFFFFFF FFFFFFFF 0000F0FF 78E00700 FFFFFF1F FFFFFFFF FFFFFFFF 0000F8FF
  70C00700 FFFFFF3F FFFFFFFF FFFFFFFF 0000FCFF E0810700 FFFFFF7F FFFFFFFF
  FFFFFFFF 0000FFFF C0030700 FFFFFFFF FFFFFFFF FFFFFFFF 0080FFFF 81070200
  FFFFFFFF FFFFFFFF FFFFFFFF 00C0FFFF 030F0000 FFFFFFFF FFFFFFFF FFFFFFFF
  00E0FFFF 071E0000 FFFFFFFF FFFFFFFF FFFFFFFF 00F8FFFF 0F3C0000 FFFFFFFF
  FFFFFFBF FFFFFFFF 00F8FFFF 1F700000 FFFFFFFF FFFFFFBF FFFFFFFF 00FEFFFF
  3FE00100 FFFFFFFF FFFFFF9F FFFFFFFF 00FFFFFF 7FC00300 FFFFFFFF FFFFFF81
  FFFFFFFF 80FFFFFF FF800700 FFFFFFFF FFFF0180 FFFFFFFF E0FFFFFF FF012F00
  FFFFFFFF FF070080 FFFFFFFF F0FFFFFF FF037E00 FFFFFFFF 0F000080 FFFFFFFF
  F8FFFFFF FF07FC00 FFFFFFFF 00000080 FFFFFF7F F0FFFFFF FF0FF801 FFFFFFFF
  00000080 FFFFFF1F E0FFFFFF FF1FF002 FFFFFFFF 00000080 FFFFFF03 C0FFFFFF
  FF3FE01E FFFFFFFF 00000080 FFFFFF00 80FFFFFF FF7FE03F FFFFFFFF 00000080
  FFFF1F00 00FFFFFF FFFFE0FF FFFFFFFF 00000080 FFFF0700 01FCFFFF FFFFE0FF
  FFFFFFFF 00000080 FFFF0300 03F8FFFF FF7F80FF FFFFFFFF 00000080 FFFF0100
  07F0FFFF FF7F00DF FFFFFFFF 00000080 FF7F0000 0FF0FFFF FF7F00F0 FFFFFFFF
  00000080 FF3F0000 1FF0FFFF FF7F01E0 FFFFFFFF 00000080 FF1F0000 3FF0FFFF
  FFFF01C1 FFFFFFFF 00000080 FF0F0000 0FF8FFFF FFFF0700 FFFFFFFF 00000080
  FF030000 00F8FFFF FFFF1F00 FFFFFFFF 00000080 FF010000 20F8FFFF FFFF3F00
  FFFFFFFF 00000080 7F000000 00F8FFFF FFFFFF01 FFFFFFFF 00000080 1F000000
  00FCFFFF FFFFFF03 FFFFFFFF 00000080 03000000 00FCFFFF FFFFFF0F FFFFFFFF
  00000080 00000000 00FEFF7F FFFFFF7F FFFFFFFF 67301C8E 000000C0 00FFFF0F
  FFFFFF7F FFFFFFFF A0482291 00000040 00FE3F00 FFFFFFFF FFFFFFFF 2084A2AC
  00000080 03F80000 FFFFFFFF FFFFFFFF 218484AA 00000000 06080000 FFFFFFFF
  FFFFFFFF 218488AC 00000000 05080000 FFFFFFFF FFFFFFFF 228490AA 00000000
  01080000 FFFFFFFF FFFFFFFF 2248A0AA 00000000 0F040000 FFFFFFFF FFFFFFFF
  72303E91 00000000 FF030000 FFFFFFFF FFFFFFFF 0000008E 00000000 BC000000
  FF7F0000 FFFFFFFF 00000080 00000000 00000000 FF3F0000 FFFFFFFF 00000080
  00000000 00000000 1F000000 FFFFFFFF 00000080 00000000 00000000 00000000
  FFFFFF3F
End DefineFont
